<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return Inertia::render('welcome');
})->name('home');

Route::middleware(['auth', 'verified','ensure.business.details'])->group(function () {
    Route::get('dashboard', function () {
        return Inertia::render('dashboard');
    })->name('dashboard');

    Route::resource("customers",\App\Http\Controllers\Customer\IndexController::class);

    Route::resource('interior-designers',\App\Http\Controllers\InteriorDesigner\IndexController::class);

    Route::resource("estimates",\App\Http\Controllers\Estimate\IndexController::class);
    Route::post("estimates/{estimate}/updateNote",[\App\Http\Controllers\Estimate\IndexController::class,'updateNotes'])->name('estimates.update.notes');
    Route::get("estimates/{estimate}/pdf",[\App\Http\Controllers\Estimate\IndexController::class,'pdf'])->name('estimates.pdf');
    Route::resource("estimates.sections",\App\Http\Controllers\Estimate\Section\IndexController::class);
    Route::resource('estimates.items', \App\Http\Controllers\Estimate\Item\IndexController::class);
    Route::post('estimates/{estimate}/items/reorder',[\App\Http\Controllers\Estimate\Item\IndexController::class,'reorder'])->name('estimates.items.reorder');    

    Route::resource("invoices",\App\Http\Controllers\Invoice\IndexController::class);
    Route::post("invoices/{invoice}/updateNote",[\App\Http\Controllers\Invoice\IndexController::class,'updateNotes'])->name('invoices.update.notes');
    Route::get("invoices/{invoice}/pdf",[\App\Http\Controllers\Invoice\IndexController::class,'pdf'])->name('invoices.pdf');
    Route::resource("invoices.sections",\App\Http\Controllers\Invoice\Section\IndexController::class);
    Route::resource('invoices.items', \App\Http\Controllers\Invoice\Item\IndexController::class);
    Route::post('invoices/{invoice}/items/reorder',[\App\Http\Controllers\Invoice\Item\IndexController::class,'reorder'])->name('invoices.items.reorder');    

    Route::resource("customer_addresses",\App\Http\Controllers\Customer\Address\IndexController::class);
    
    Route::post('customer_addresses/options',[\App\Http\Controllers\Customer\Address\IndexController::class,'listAsOptions'])->name('customer_addresses.options');

});

require __DIR__.'/settings.php';
require __DIR__.'/auth.php';
