import AlertBox from '@/components/jbs/alert-box';
import ButtonJbs from '@/components/jbs/button';
import GridView from '@/components/jbs/grid-view';
import TableView from '@/components/jbs/table-view';
import AppLayout from '@/layouts/app-layout';
import { type BreadcrumbItem } from '@/types';
import { Head, usePage } from '@inertiajs/react';
import { Add } from '@mui/icons-material';
import { ButtonGroup } from 'rsuite';
import { useEffect, useState } from 'react';

const breadcrumbs: BreadcrumbItem[] = [
    {
        title: 'Invoices',
        href: '#',
    },
];

export default function Dashboard({ columns = [], dataset = [] }) {
    const { flash } = usePage().props as { flash: { success?: string } };

    const [tableColumn, setTableColumns] = useState([]);

    const [tableData, setTableData] = useState([]);

    useEffect(() => {
        setTableColumns(columns);
        setTableData(dataset);
    }, [columns, dataset]);

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <Head title="Invoices" />
            <AlertBox flash={flash} />
            <GridView title="Invoices">
                <GridView.Title>Invoices</GridView.Title>
                <GridView.Action>
                    <ButtonJbs href={route('invoices.create')} startIcon={<Add />}>
                        Add
                    </ButtonJbs>
                </GridView.Action>
                <GridView.Body>
                    <TableView
                        columns={tableColumn}
                        dataset={tableData}
                        showSelection={true}
                        action={true}
                        renderers={{
                            action: (value, record) => (
                                <>
                                    <ButtonGroup variant="outlined">
                                        <ButtonJbs variant="text" href={route('invoices.items.index', { invoice: record.invoice_id })}> ITEMS </ButtonJbs>
                                        <ButtonJbs variant="text" href={route('invoices.pdf', { invoice: record.invoice_id })} newtab > PDF </ButtonJbs>
                                    </ButtonGroup>
                                </>
                            ),
                        }}
                    />
                </GridView.Body>
            </GridView>
        </AppLayout>
    );
}
