import Alert from '@mui/material/Alert';
import Box from '@mui/material/Box';
import Grid from '@mui/material/Grid';
import getSlot from './slots';

const Title = ({ children }) => <>{children}</>;
Title.displayName = 'FormView.Title';

const Body = ({ children }) => <>{children}</>;
Body.displayName = 'FormView.Body';

const FormView = (props) => {
    const { children } = props;

    const title = getSlot(children, Title.displayName);
    const body = getSlot(children, Body.displayName);

    return (
        <Box sx={{ flexGrow: 1 }}>
            <Grid container spacing={2}>
                <Grid size={{ xs: 12, md: 12 }}>{title}</Grid>       
                <Grid size={{ xs: 12, md: 12 }}>{body}</Grid>
            </Grid>
        </Box>
    );
};

FormView.Title = Title;
FormView.Body = Body;
export default FormView;
