<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->uuid('invoice_item_id')->primary();
            $table->uuid('invoice_id');
            $table->uuid('invoice_section_id');
            
            $table->string('item_name');
            $table->text('description')->nullable();

            $table->string('unit_type');
            $table->decimal('length_value', 10, 2)->nullable();
            $table->string('length_unit')->nullable();
            $table->decimal('width_value', 10, 2)->nullable();
            $table->string('width_unit')->nullable();
            $table->decimal('height_value', 10, 2)->nullable();
            $table->string('height_unit')->nullable();

            $table->decimal('quantity', 10, 2)->default(0);
            $table->decimal('unit_price', 10, 2)->default(0);
            $table->decimal('total', 10, 2)->default(0);
            $table->integer('sort_order')->default(0);
            
            

            $table->foreign('invoice_id')->references('invoice_id')->on('invoices')->onDelete('cascade');
            $table->foreign('invoice_section_id')->references('invoice_section_id')->on('invoice_sections')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_items');
    }
};
