<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('estimate_items', function (Blueprint $table) {
            $table->uuid('estimate_item_id')->primary();
            $table->uuid('estimate_id');
            $table->uuid('estimate_section_id');
            
            $table->string('item_name');
            $table->text('description')->nullable();

            $table->string('unit_type');
            $table->decimal('length_value', 10, 2)->nullable();
            $table->string('length_unit')->nullable();
            $table->decimal('width_value', 10, 2)->nullable();
            $table->string('width_unit')->nullable();
            $table->decimal('height_value', 10, 2)->nullable();
            $table->string('height_unit')->nullable();

            $table->decimal('quantity', 10, 2)->default(0);
            $table->decimal('unit_price', 10, 2)->default(0);
            $table->decimal('total', 10, 2)->default(0);
            $table->integer('sort_order')->default(0);
            
            

            $table->foreign('estimate_id')->references('estimate_id')->on('estimates')->onDelete('cascade');
            $table->foreign('estimate_section_id')->references('estimate_section_id')->on('estimate_sections')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('estimate_items');
    }
};
