<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('estimates', function (Blueprint $table) {
            $table->uuid('estimate_id')->primary();
            $table->string('estimate_number');
            $table->uuid('user_id');
            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->uuid('customer_id');
            $table->foreign('customer_id')->references('customer_id')->on('customers')->onDelete('cascade');
            $table->uuid('customer_address_id');
            $table->foreign('customer_address_id')->references('customer_address_id')->on('customer_addresses')->onDelete('cascade');
            $table->uuid('interior_designer_id')->nullable();
            $table->foreign('interior_designer_id')->references('interior_designer_id')->on('interior_designers')->onDelete('cascade');
            $table->longText('notes')->nullable();
            $table->dateTime('estimate_generated_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('estimates');
    }
};
