<?php

namespace App\Models\Customer;

use App\Traits\HasUuid;
use App\Models\BaseModel;
use DB;

class Address extends BaseModel
{
    use HasUuid;
    protected $primaryKey = 'customer_address_id';
    protected $table = 'customer_addresses';

    protected $fillable = [
        'customer_id',
        'address_line_1',
        'address_line_2',
        'city',
        'state',
        'postal_code',
        'country',
    ];

    public function getFormattedAddressQuery($as = "label"){
        return DB::raw("CONCAT($this->table.address_line_1,', ',$this->table.address_line_2,', ',$this->table.state,', ',$this->table.city,' - ',$this->table.postal_code,', ',$this->table.country) as $as");
    }

    public function getAddressAsOptions($data = []){
         $selectedColumns = [
            $this->table.'.customer_address_id as value',
            $this->getFormattedAddressQuery()
        ];
        $this->setSelect();
        if(!empty($data['customer_id'])){
            $this->addFieldToFilter($this->table,'customer_id','=',$data['customer_id']);
        }
        return $this->get($selectedColumns);
    }

    public function saveRecord($data = []){
        $response = ['success' => false,'message' => 'Failed to create address.'];
        $address = self::create($data);
        $response['success'] = true;
        $response['message'] = "";
        $response['customer_address_id'] = $address->customer_address_id;
        return $response;
    }

}
