<?php

namespace App\Http\Controllers\InteriorDesigner;

use App\Http\Controllers\Controller;
use App\Models\InteriorDesigner;
use Illuminate\Http\Request;

class IndexController extends Controller
{

    public function __construct(InteriorDesigner $model)
    {
        $this->modelObject = $model;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = [
            'columns' => $this->modelObject->getGridColumns(),
            'dataset' => $this->modelObject->list(),
        ];
        return $this->view('interior_designer/list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return $this->view('interior_designer/create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
         $request->validate([
            'name' => 'required|string|max:255',
            'mobile' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
        ]);

        $customer = $this->modelObject->saveRecord($request->all());
        return redirect()->intended(route('interior-designers.index'))->with($customer['success'] ? 'success' : 'error',$customer['message']);
    }

    /**
     * Display the specified resource.
     */
    public function show(InteriorDesigner $interiorDesigner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(InteriorDesigner $interiorDesigner)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, InteriorDesigner $interiorDesigner)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(InteriorDesigner $interiorDesigner)
    {
        //
    }
}
