<?php

namespace App\Http\Controllers\Estimate\Item;

use App\Models\Estimate\Item;
use App\Http\Controllers\Controller;
use App\Models\Estimate;
use Illuminate\Http\Request;

class IndexController extends Controller
{

    public function __construct(Item $estimateItem)
    {
        $this->modelObject = $estimateItem;
        // dd('sdsd');
    }

    public function index(Request $request)
    {
        $data = ['estimate_id' => $request->estimate];
        return $this->view('estimate/item/list', $data);
    }

    public function store($estimate_id,Request $request){
        $data = $request->all();
        $data['estimate_id'] = $estimate_id;
        return $this->modelObject->saveRecord($data);
    }

    public function destroy(Estimate $estimate,Item $item){
        return $this->modelObject->remove($item->estimate_item_id);
    }

    public function reorder(Request $request){
        return $this->modelObject->reorder($request->all());
    }

    


    
}
