<?php

namespace App\Http\Controllers\Estimate;

use App\Models\Estimate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\InteriorDesigner;

class IndexController extends Controller
{

    public function __construct(Estimate $estimate)
    {
        $this->modelObject = $estimate;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = [
            'columns' => $this->modelObject->getGridColumns(),
            'dataset' => $this->modelObject->list(),
        ];
        return $this->view('estimate/list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $data = [
            'customers' => (new Customer)->getCustomerAsOptions(),
            'interior_designers' => (new InteriorDesigner)->getInteriorDesignersAsOptions()
        ];
        return $this->view('estimate/create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $validationRules = [
            'customer_id' => 'required',
        ];
        if ($data['address']['customer_address_id'] == ''){
            $validationRules['address.customer_address_id'] = 'required';
        }
        
        if ($data['address']['customer_address_id'] == '0') {
            $validationRules['address.address_line_1'] = 'required';
            $validationRules['address.address_line_2'] = 'required';
            $validationRules['address.city'] = 'required';
            $validationRules['address.state'] = 'required';
            $validationRules['address.postal_code'] = 'required';
            $validationRules['address.country'] = 'required';
        }
        $request->validate($validationRules,[
            'customer_id.required' => 'Please select customer',
            'address.customer_address_id.required' => 'Please select address',
            'address.address_line_1.required' => 'This field is required',
            'address.address_line_2.required' => 'This field is required',
            'address.city.required' => 'This field is required',
            'address.state.required' => 'This field is required',
            'address.postal_code.required' => 'This field is required',
            'address.country.required' => 'This field is required',
        ]);


        $estimate = $this->modelObject->saveRecord($data);
        return redirect()->intended(route('estimates.index'))->with($estimate['success'] ? 'success' : 'error', $estimate['message']);
    }

    /**
     * Display the specified resource.
     */
    public function show(Estimate $estimate)
    {
        return $this->modelObject->getDetails($estimate->estimate_id);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Estimate $estimate)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function updateNotes(Request $request, Estimate $estimate)
    {
        return $this->modelObject->updateNotes($estimate->estimate_id,$request->notes);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Estimate $estimate)
    {
        //
    }

    
    public function pdf($estimate_id,Request $request){
        return $this->modelObject->getPdf($estimate_id);
    }
}
