<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use Illuminate\Http\Request;

class IndexController extends Controller
{

    public function __construct(Customer $customer)
    {
        $this->modelObject = $customer;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = [
            'columns' => $this->modelObject->getGridColumns(),
            'dataset' => $this->modelObject->list(),
        ];
        return $this->view('customer/list',$data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return $this->view('customer/create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'mobile' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
        ]);

        $customer = $this->modelObject->saveRecord($request->all());
        return redirect()->intended(route('customers.index'))->with($customer['success'] ? 'success' : 'error',$customer['message']);
    }

    /**
     * Display the specified resource.
     */
    public function show(Customer $customer)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Customer $customer)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Customer $customer)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Customer $customer)
    {
        //
    }


}
